/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.base.StringUtils;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;

public class VWBootstrapURL {
    protected static Logger logger = Logger.getLogger("filenet.vw.server");
    private static final String m_className = "VWBootstrapURL";
    private static final long serialVersionUID = 464L;
    private static final VWString vws_invalidBootstrapUri = new VWString("vw.server.invalidBootstrapUri", "{0} is not a valid bootstrap URI.");
    private static final VWString vws_invalidCEUri = new VWString("vw.server.invalidCEUri", "{0} is not a valid Content Engine URI.");
    private static final VWString vws_invalidCPUri = new VWString("vw.server.invalidCPUri", "{0} is not a valid Connection Point URI.");
    private static final VWString vws_missingCPUri = new VWString("vw.server.missingCPUri", "{0} does not contain a valid Connection Point URI.");
    private static final String BOOTSTRAPCEURI_PREFIX = "bootstrapCEURI:";
    private static final String CPURIEQ = "cpURI=";
    private URI m_ceURI = null;
    private URI m_cpURI = null;
    private String m_origURI = null;

    public static String _get_FILE_DATE() {
        return "$Date:   31 Jul 2007 21:21:32  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    public URI getCEURI() {
        return this.m_ceURI;
    }

    public URI getCPURI() {
        return this.m_cpURI;
    }

    public static String GetBootstrapURI(String ceURI, String cpURI) throws MalformedURLException {
        return new VWBootstrapURL(ceURI, cpURI).toString();
    }

    public VWBootstrapURL(String ceURI, String cpURI) throws MalformedURLException {
        try {
            this.m_cpURI = new URI(cpURI);
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(vws_invalidCPUri.toString(cpURI));
        }
        try {
            if (ceURI != null) {
                this.m_ceURI = new URI(ceURI);
                this.m_origURI = BOOTSTRAPCEURI_PREFIX + this.m_ceURI.toASCIIString() + (this.m_ceURI.getQuery() == null ? "?" : "&") + CPURIEQ + this.m_cpURI.toASCIIString();
            } else {
                this.m_origURI = "bootstrapCEURI:null?cpURI=" + this.m_cpURI.toASCIIString();
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "ctor1", this.m_origURI);
            }
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(vws_invalidCEUri.toString(ceURI));
        }
    }

    public VWBootstrapURL(String url) throws MalformedURLException {
        String m_method = "ctor2:" + url;
        this.m_origURI = url;
        try {
            block11: {
                try {
                    String qS;
                    logger.entering(m_className, m_method);
                    if (url == null || !url.startsWith(BOOTSTRAPCEURI_PREFIX)) {
                        throw new MalformedURLException(vws_invalidBootstrapUri.toString(url));
                    }
                    int qSIndex = (url = url.substring(BOOTSTRAPCEURI_PREFIX.length())).indexOf(qS = "?cpURI=");
                    if (qSIndex == -1) {
                        throw new MalformedURLException(vws_missingCPUri.toString(this.m_origURI));
                    }
                    String s = url.substring(qSIndex + qS.length());
                    try {
                        String s2 = URLDecoder.decode(s, "UTF-8");
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, s + ", After decoded=" + StringUtils.printBytes(s2, "UTF-8"));
                        }
                        this.m_cpURI = new URI(s2);
                    }
                    catch (Exception ex) {
                        logger.throwing(m_className, m_method, ex);
                        this.m_cpURI = new URI(s);
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "CPURI=" + this.m_cpURI);
                    }
                    if (url.startsWith("null")) {
                        this.m_ceURI = null;
                        break block11;
                    }
                    url = url.substring(0, qSIndex);
                    this.m_ceURI = new URI(url);
                }
                catch (URISyntaxException ue) {
                    throw new MalformedURLException(vws_invalidBootstrapUri.toString(this.m_origURI));
                }
            }
            Object var8_9 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    public String toString() {
        return this.m_origURI;
    }

    public static void main(String[] args) {
        VWBootstrapURL url;
        try {
            url = new VWBootstrapURL("bootstrapCEURI:corbaloc::hq-deploy7:9810,:hq-deploy12:9810/cell/clusters/dep7dep12/FileNet/Engine?cpURI=PE1");
            System.out.println("Got it OK!!" + url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            url = new VWBootstrapURL("bootstrapCEURI:http://jpdcp8401:9080/wsi/FNCEWS40DIME/?cpURI=%E3%81%AB%E3%81%BB%E3%82%93%E3%81%9420");
            System.out.println("Got it OK!!" + url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (args.length == 0) {
            args = new String[]{"t3://hqbmp44:7001/FileNet/Engine", "localhostabc:32771/this%20abcdef", "t3://hqbmp34:32771/FileNet/Engine?Gohome", "corba://myHost:222/1", "t3://hqbmp34:32771/FileNet/Engine", "corba://myHost:-1/0034", "t3://hqbmp34:32771/FileNet/Engine", "localhost:32771/vw%20router", null, "vwrouter"};
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                if (i + 1 < args.length) {
                    String ceURI = args[i];
                    String cpURI = args[++i];
                    System.out.println("Examinine ceURI=" + ceURI + ", cpUri=" + cpURI);
                    VWBootstrapURL r = new VWBootstrapURL(ceURI, cpURI);
                    VWBootstrapURL.printBootstrapURL("Original", r);
                    String s = r.toString();
                    System.out.println("New=" + s);
                    r = new VWBootstrapURL(s);
                    VWBootstrapURL.printBootstrapURL("New", r);
                }
            }
            catch (Exception e) {
                System.out.println("Got excception..");
                e.printStackTrace();
            }
            System.out.println("----------");
        }
    }

    private static void printBootstrapURL(String msg, VWBootstrapURL r) {
        System.out.println(msg);
        System.out.println(r.toString());
        URI ceURI = r.getCEURI();
        System.out.println("ceURI = " + (ceURI == null ? "null" : ceURI.toASCIIString()));
        System.out.println("cpURI = " + r.getCPURI().toASCIIString());
    }
}

